package gov.va.genisis2Test.util.rest.helper;

import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.util.rest.helper.ResponseWrapper;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;

/**
 * 
 * @author1 Janet Lopez
 * 
 * The Class ResponseWrapperTest.
 * 
 * Description: In this ResponseWrapperTest Class which extends the abstract
 * class, AbstractMockMvcTests, junit tests are defined.
 * 
 */
public class ResponseWrapperTest extends AbstractMockMvcTests {
	
	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(ResponseWrapperTest.class);

	/**
	 * Test response wrapper.
	 */
	@Test
	public void TestResponseWrapper() {

		logger.info("**********Junit Test Response Wrapper**********");

		ResponseWrapper wrapper = new ResponseWrapper();
		String message = StringUtils.EMPTY;
		Assert.assertNull(wrapper.getResponse());
		Assert.assertEquals(message, wrapper.getMessage());
		Assert.assertFalse(wrapper.getSuccess());

		wrapper.setSuccess(true);
		wrapper.setMessage("messageTestOne");
		wrapper.setResponse("responseTestOne");

		Assert.assertTrue(wrapper.getSuccess());
		Assert.assertEquals("messageTestOne", wrapper.getMessage());
		Assert.assertEquals("responseTestOne", wrapper.getResponse());

		logger.info("**********End of Junit Test Response Wrapper**********");

	}

}
